<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\CafeRepository;
use App\Http\Requests\Admin\CafeRequests\CafeStoreRequest;
use App\Http\Requests\Admin\CafeRequests\CafeUpdateRequest;
use Illuminate\Support\Facades\DB;

class CafeController extends Controller
{

    public $cafes;

    public function __construct(CafeRepository $cafes)
    {
        $this->cafes = $cafes;
    }

    public function index($offset, $limit)
    {
        try{
            $cafes = $this->cafes->index($offset, $limit);
            return view('admin.cafes.index', compact('cafes'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->cafes->create();
    }

    public function store(CafeStoreRequest $request)
    {
        try{
            $this->cafes->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        $cafe = $this->cafes->edit($id);
        return view('admin.cafes.update', compact('cafe'));
    }

    public function update(CafeUpdateRequest $request, $id)
    {
        try{
            $this->cafes->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            DB::rollBack();
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->cafes->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->cafes->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->cafes->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->cafes->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->cafes->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->cafes->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->cafes->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->cafes->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->cafes->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->cafes->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function uploadAlbums(Request $request, $id)
    {
        try{
            return $this->cafes->uploadAlbums($request, $id);
        }catch(\Exception $e){
            // return response()->json(['error' => $e], 400);
            return response()->json(['error' => 'There Is Something Wrong, Please Contact Technical Support'], 400);
        }
    }

    public function deleteImg(Request $request, $id)
    {
        try{
            $this->cafes->deleteImg($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function orders($offset, $limit)
    {
        try{
            $orders = $this->cafes->orders($offset, $limit);
            return view('admin.cafes.orders', compact('orders'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}