<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\CaptainRepository;
use App\Http\Requests\Admin\CaptainRequests\CaptainStoreRequest;
use App\Http\Requests\Admin\CaptainRequests\CaptainUpdateRequest;

class CaptainController extends Controller
{

    public $captains;

    public function __construct(CaptainRepository $captains)
    {
        $this->captains = $captains;
    }

    public function index($offset, $limit)
    {
        try{
            return $this->captains->index($offset, $limit);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->captains->create();
    }

    public function store(CaptainStoreRequest $request)
    {
        try{
            $this->captains->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->captains->edit($id);
    }

    public function update(CaptainUpdateRequest $request, $id)
    {
        try{
            $this->captains->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->captains->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->captains->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->captains->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->captains->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->captains->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->captains->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->captains->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->captains->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->captains->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->captains->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}