<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\OptionRepository;
use App\Http\Requests\Admin\OptionRequests\OptionStoreRequest;
use App\Http\Requests\Admin\OptionRequests\OptionUpdateRequest;

class OptionController extends Controller
{

    public $options;

    public function __construct(OptionRepository $options)
    {
        $this->options = $options;
    }

    public function index($offset, $limit)
    {
        try{
            return $this->options->index($offset, $limit);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->options->create();
    }

    public function store(OptionStoreRequest $request)
    {
        try{
            $this->options->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->options->edit($id);
    }

    public function update(OptionUpdateRequest $request, $id)
    {
        try{
            $this->options->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->options->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->options->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->options->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->options->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->options->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->options->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->options->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->options->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->options->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->options->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}