<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\RoomTypeRepository;
use App\Http\Requests\Admin\RoomTypeRequests\RoomTypeStoreRequest;
use App\Http\Requests\Admin\RoomTypeRequests\RoomTypeUpdateRequest;

class RoomTypeController extends Controller
{

    public $roomTypes;

    public function __construct(RoomTypeRepository $roomTypes)
    {
        $this->roomTypes = $roomTypes;
    }

    public function index($offset, $limit)
    {
        try{
            return $this->roomTypes->index($offset, $limit);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->roomTypes->create();
    }

    public function store(RoomTypeStoreRequest $request)
    {
        try{
            $this->roomTypes->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->roomTypes->edit($id);
    }

    public function update(RoomTypeUpdateRequest $request, $id)
    {
        try{
            $this->roomTypes->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->roomTypes->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->roomTypes->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->roomTypes->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->roomTypes->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->roomTypes->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->roomTypes->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->roomTypes->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->roomTypes->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->roomTypes->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->roomTypes->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}