<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\WalletRepository;
use App\Http\Requests\Admin\WalletRequests\WalletStoreRequest;
use App\Http\Requests\Admin\WalletRequests\WalletUpdateRequest;

class WalletController extends Controller
{

    public $wallets;

    public function __construct(WalletRepository $wallets)
    {
        $this->wallets = $wallets;
    }

    public function index(Request $request, $offset, $limit)
    {
        try{
            $wallets = $this->wallets->index($request, $offset, $limit);
            return view('admin.wallets.index', compact('wallets'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->wallets->create();
    }

    public function store(WalletStoreRequest $request)
    {
        try{
            $this->wallets->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->wallets->edit($id);
    }

    public function update(WalletUpdateRequest $request, $id)
    {
        try{
            $this->wallets->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->wallets->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->wallets->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->wallets->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->wallets->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->wallets->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->wallets->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->wallets->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->wallets->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->wallets->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->wallets->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function confirm_withdraw($id)
    {
        try{
            $this->wallets->confirm_withdraw($id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}