<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\UserRequesrs\StoreGuideOrderRequest;
use App\Http\ServicesLayer\FairbaseServices\FairbaseService;
use App\Models\FavorateGuide;
use App\Models\GuideOrder;
use App\Models\Notification;
use App\Models\User;
use App\Models\WalletTransaction;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{

    public $user;
    public $guideOrder;
    public $favorateGuide;
    public $fairbaseService;
    public $notification;
    public $walletTransaction;

    public function __construct(
        User $user, GuideOrder $guideOrder, FavorateGuide $favorateGuide, FairbaseService $fairbaseService, Notification $notification,
        WalletTransaction $walletTransaction
    ){
        $this->user = $user;
        $this->guideOrder = $guideOrder;
        $this->favorateGuide = $favorateGuide;
        $this->fairbaseService = $fairbaseService;
        $this->notification = $notification;
        $this->walletTransaction = $walletTransaction;
        $this->middleware('auth:api', ['except' => ['guides', 'details']]);
    }

    public function guides(Request $request, $offset, $limit)
    {
        try{
            $records = $this->user
            ->when($request->country_id, function($q) use ($request) {
                $q->where('country_id', $request->country_id);
            })
            ->when($request->day_price_from && $request->day_price_to, function($q) use ($request) {
                $q->whereBetween('day_price', [$request->day_price_from, $request->day_price_to]);
            })
            ->when($request->day_price_from && !$request->day_price_to, function($q) use ($request) {
                $q->where('day_price', '>=', $request->day_price_from);
            })
            ->when(!$request->day_price_from && $request->day_price_to, function($q) use ($request) {
                $q->where('day_price', '<=', $request->day_price_to);
            })
            ->when($request->hour_price_from && $request->hour_price_to, function($q) use ($request) {
                $q->whereBetween('hour_price', [$request->hour_price_from, $request->hour_price_to]);
            })
            ->when($request->hour_price_from && !$request->hour_price_to, function($q) use ($request) {
                $q->where('hour_price', '>=', $request->hour_price_from);
            })
            ->when(!$request->hour_price_from && $request->hour_price_to, function($q) use ($request) {
                $q->where('hour_price', '<=', $request->hour_price_to);
            })->guides()->unArchive()->orderBy('id', 'DESC')->withAvg('ratings', 'rating')->offset($offset)->limit(PAGINATION_COUNT)->get();
            return responseJson(200, "success", $records);
        }catch(\Exception $e){
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }

    public function details($id)
    {
        $record = $this->user->where('id', $id)->guides()->withAvg('ratings', 'rating')->with([
            'ratings', 'languages', 'country', 'days', 'album'
        ])->first();
        return responseJson(200, "success", $record);
    }

    public function myOrders(Request $request, $offset)
    {
        try{
            $auth = auth()->user();
            $records = $this->guideOrder->where('guide_id', $auth->id)
            ->when($request->status, function($q) use ($request) {
                $q->where('status', $request->status);
            })->with(['guide', 'user'])->orderBy('id', 'DESC')->offset($offset)
            ->limit(PAGINATION_COUNT)->get();
            return responseJson(200, "success", $records);
        }catch(\Exception $e){
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }
    
    public function orderStatus(Request $request, $id)
    {
        
        $validator = Validator::make($request->all(), [
            'status' => 'required|in:2,3,4,5,6',
        ]);
        if ($validator->fails()) {
            return responseJson(400, "Bad Request", $validator->errors()->first());
        }

        $auth = auth()->user();
        $order = $this->guideOrder->where('id', $id)->with(['user', 'chat_group.members.user' => function($q){
            $q->with(['wallet', 'group_transactions']);
        }])->first();
        // $order = $this->guideOrder->where('id', $id)->where('guide_id', $auth->id)->with('user')->first();
        if ($order) {

            if ((int)$request->status == 6 && (int)$order->status !== 2) {
                if ((int)$order->status == 1) {
                    return responseJson(404, "the provider has not been confirmed yet.");
                }
                return responseJson(404, "this action is not currently suitable for this request.");
            }
            if ((int)$request->status == 6) {
                if (!is_null($order->chat_group)) {
                    if ($order->chat_group?->added_by_id == $auth->id) {
                        
                        $errors = null;
                        $usersHaveErr = 0;

                        $n = $order->chat_group->members->count();
                        $costCents = (int) round($order->cost * 100);
                        $base = intdiv($costCents, $n);
                        $remainder = $costCents % $n;
                        
                        foreach ($order->chat_group->members as $i => $member) {
                            
                            $deposit = array_sum(array_column(
                                $member->user->group_transactions->where('chat_group_id', $order->chat_group_id)->where('type', 1)->where('status', 1)->toArray(), 
                                'amount'
                            ));
                            $withdrow = array_sum(array_column(
                                $member->user->group_transactions->where('chat_group_id', $order->chat_group_id)->where('type', 2)->where('status', 1)->toArray(), 
                                'amount'
                            ));
                            $balance = $deposit - $withdrow;
                            $shareCents = $base + ($i < $remainder ? 1 : 0);
                            $costPerPerson = $shareCents / 100;
                            if ($costPerPerson > $balance) {
                                $usersHaveErr++;
                                $errors .= $member->user->name . " - "; 
                            }

                            $transactions[] = [
                                'type' => 2, // withdrow
                                'status' => 1, // compeleted
                                'created_at' => now(), 'updated_at' => now(),
                                'chat_group_id' => $member->user->group_transactions[0]->chat_group_id ?? null,
                                'amount' => $costPerPerson, 'wallet_id' => $member->user->wallet?->id, 'user_id' => $member->user->id,
                                'orderable_id' => $id, 'orderable_type' => get_class($order),
                            ];
                        }
                        // if (!is_null($errors)) {
                        //     if($usersHaveErr > 1){ $errorMsg = 'users: '. $errors .'they not have balance'; }
                        //     else { $errorMsg = 'user: '. $errors .'not have balance'; }
                        //     return responseJson(404, $errorMsg);
                        // }
                    } else {
                        return responseJson(404, "you dont have permission, you must be the group owner");
                    }
                } else if ($order->added_by == $auth->id){
                    $auth->load(['personal_transactions']);
                    $deposit = array_sum(array_column(
                        $auth->user->personal_transactions->where('type', 1)->where('status', 1)->toArray(), 
                        'amount'
                    ));
                    $withdrow = array_sum(array_column(
                        $auth->user->personal_transactions->where('type', 2)->where('status', 1)->toArray(), 
                        'amount'
                    ));
                    $balance = $deposit - $withdrow;
                    if ($order->cost > $balance) {
                        return responseJson(404, "not have balance");
                    }
                    $transactions[] = [
                        'type' => 2, // withdrow
                        'status' => 1, // compeleted
                        'created_at' => now(), 'updated_at' => now(),
                        'amount' => $order->cost, 'wallet_id' => $auth->user->wallet->id, 'user_id' => $auth->user->id,
                        'orderable_id' => $id, 'orderable_type' => get_class($order),
                    ];
                } else {
                    return responseJson(404, "you dont have permission, you must be the group owner");
                }
            } else {
                if ($order->provider_id !== $auth->id) {
                    return responseJson(404, "not found");
                }
            }
            if ((int)$order->status == 3 || (int)$order->status == 4 || (int)$order->status == 5) {
                return responseJson(404, "this order is ended");
            }
            if ((int)$request->status == 3 && (int)$order->status == 1) {
                return responseJson(404, "must be confirmed first");
            }
            try{
                DB::beginTransaction();
                $order->update([
                    'status' => $request->status,
                    'canceled_by' => $request->status == 4 ? 1 : null,
                ]);
                if (count($transactions) > 0) {
                    $this->walletTransaction->insert($transactions);
                }
                DB::commit();
                
                $status = '';
                $request->status == 2 ? $status = "confirmed" : '';
                $request->status == 3 ? $status = "completed" : '';
                $request->status == 4 ? $status = "canceled" : '';
                if ($order->user?->fcm_token) {
                    // 1 => guides, 2 => cars, 3 => hotels, 4 => restaurants, 5 => cafes
                    $pushNotification = $this->fairbaseService->pushNotification(
                        $order->user?->fcm_token, 'change order status', "order number #$order->id has been $status", 1, $order->id
                    );
                }
                $this->notification->create([
                    'title' => 'change order status',
                    'content' => "order number #$order->id has been $status",
                    'order_id' => $order->id,
                    'chat_group_id' => $order->chat_group_id,
                    'provider_id' => $auth->id,
                    'user_id' => $order->added_by,
                    'serviceable_id' => $order->guide_id,
                    'serviceable_type' => "App\Models\User",
                ]);
                return responseJson(200, "success");
            }catch(\Exception $e){
                DB::rollBack();
                return responseJson(404, "There is something wrong , please contact technical support");
            }
        }else{
            return responseJson(404, "Not Found");
        }
    }

    public function makeOrder(StoreGuideOrderRequest $request)
    {
        try {
            $guide = $this->user->where('id', $request->guide_id)->first();
            if ($guide) {
                $day = $guide->days()->where('day', $request->day)->first();
                if ($day && isset($request->time) && (int)$request->reservation_type == 2) {
                    $start = Carbon::createFromFormat('h:i A', $day->start);
                    $end = Carbon::createFromFormat('h:i A', $day->end);

                    $timeRaw = trim($request->time);
                    $timeRaw = str_replace(['صباحًا', 'صباحا', 'مساء', 'مساءً'], ['AM', 'AM', 'PM', 'PM'], $timeRaw);
                    $time = Carbon::createFromFormat('h:i A', $timeRaw);

                    if (!$time->between($start, $end)) {
                        return responseJson(500, 'this guide not available in this time');
                    }
                }
                if ($day) {
                    $order = new $this->guideOrder();
                    
                    $order->guide_id = $request->guide_id;
                    $order->chat_group_id = $request->chat_group_id ?? null;
                    $order->date = $request->date;
                    $order->day = $request->day;
                    $order->reservation_type = $request->reservation_type;
                    $order->time = (int)$request->reservation_type == 2 ? $request->time : null;
    
                    $order->added_by = auth()->user()->id;
                    $order->status = 1; // pending
                    $order->cost = (int)$request->reservation_type == 2 ? $guide->hour_price : $guide->day_price;
                    $order->save();

                    $this->notification->create([
                        'title' => 'new order',
                        'content' => "order number #$order->id",
                        'order_id' => $order->id,
                        'chat_group_id' => $order->chat_group_id,
                        'provider_id' => $guide->id,
                        'user_id' => $order->added_by,
                        'serviceable_id' => $order->guide_id,
                        'serviceable_type' => "App\Models\User",
                    ]);
                    return responseJson(200, "success");
                }
                return responseJson(500, 'there is some thing wrong in days, please contact technical support');
            }
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        } catch (\Exception $e){
            return responseJson(500, 'there is some thing wrong , please contact technical support');
        }
    }

    public function getOrder($id)
    {
        $user = auth()->user();
        $record = $this->guideOrder->where('id', $id)->whereAny(['added_by', 'guide_id'], $user->id)->with([
            'user:id,name,img', 'guide'
        ])->first();
        return responseJson(200, "success", $record);
    }

    public function addToFavorate(Request $request, $id)
    {
        $auth = auth()->user();
        $guide = $this->user->where('id', $id)->guides()->first();
        if ($guide) {
            $this->favorateGuide->updateOrInsert(
                ['user_id' => $auth->id, 'guide_id' => $id],
                ['updated_at' => now()]
            );
            return responseJson(200, "success");
        }else{
            return responseJson(404, "Not Found");
        }
    }

}
