<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Category;
use DevxPackage\AbstractRepository;

class CategoryRepository extends AbstractRepository
{

    protected $model;

    public function __construct(Category $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'categories';
    }

    public function index($offset, $limit)
    {
        $categories = $this->pagination($offset, $limit);
        return view('admin.categories.index', compact('categories'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.categories.create');
    }

    public function store($request)
    {
        $translations = [];
        $model = new $this->model();
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        $model->save();
        $model->update($translations);
        return $model;
    }

    public function edit($id)
    {
        $category = $this->findOne($id);
        return view('admin.categories.update', compact('category'));
    }
    
    public function update($request, $id)
    {
        $translations = [];
        $model = $this->model->where('id', $id)->first();
        $model->deleteTranslations();
        foreach (config('translatable.locales') as $locale) {
            $data = [];
            if (!empty($request->input("name.$locale")))    $data['name'] = $request->input("name.$locale");
            if (!empty($data)) {
                $translations[$locale] = $data;
            }
        }
        if (!$request->hasFile('file') == null) {
            $model->img = uploadIamge($request->file('file'), $this->crudName());
        }
        $model->save();
        $model->update($translations);
        return $model;
    }

    public function archivesPage($offset, $limit)
    {
        $categories = $this->archives($offset, $limit);
        return view('admin.categories.archives', compact('categories'));
    }

}