<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\RoomType;
use DevxPackage\AbstractRepository;

class RoomTypeRepository extends AbstractRepository
{

    protected $model;

    public function __construct(RoomType $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'roomTypes';
    }

    public function index($offset, $limit)
    {
        $roomTypes = $this->pagination($offset, $limit);
        return view('admin.roomTypes.index', compact('roomTypes'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.roomTypes.create');
    }

    public function edit($id)
    {
        $roomType = $this->findOne($id);
        return view('admin.roomTypes.update', compact('roomType'));
    }

    public function archivesPage($offset, $limit)
    {
        $roomTypes = $this->archives($offset, $limit);
        return view('admin.roomTypes.archives', compact('roomTypes'));
    }

}