<?php

namespace App\Http\Requests\Admin\CafeRequests;

use Illuminate\Foundation\Http\FormRequest;

class CafeStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name.en' => 'required|string|max:254|unique:cafe_translations,name,NULL,id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:cafe_translations,name,NULL,id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:cafe_translations,name,NULL,id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:cafe_translations,name,NULL,id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:cafe_translations,name,NULL,id,locale,hi',
            
            'info.en' => 'required|string|max:254',
            'info.ar' => 'nullable|string|max:254',
            'info.fr' => 'nullable|string|max:254',
            'info.tr' => 'nullable|string|max:254',
            'info.hi' => 'nullable|string|max:254',
            
            'location.en' => 'required|string|max:254',
            'location.ar' => 'nullable|string|max:254',
            'location.fr' => 'nullable|string|max:254',
            'location.tr' => 'nullable|string|max:254',
            'location.hi' => 'nullable|string|max:254',
            
            'file' => 'required|image|mimes:jpeg,png,jpg,gif',
            'avg_prices' => 'required',
            'offer' => 'nullable',
            'map_location' => 'required|string|max:1200',
            'country_id' => 'required|exists:countries,id',
            'owner_id' => 'nullable|exists:users,id',
            
            'days' => 'required|array',
            'days.*.day' => 'required|in:السبت,الاحد,الاثنين,الثلاثاء,الاربعاء,الخميس,الجمعه',
            'days.*.start' => 'nullable|date_format:H:i',
            'days.*.end' => 'nullable|date_format:H:i',
            'days.*.day_status' => 'nullable|in:0,1,2',
            
            'times' => 'nullable|array',
            'times.*.time' => 'required|date_format:H:i',
            'times.*.type' => 'required|in:الفطار,الغداء,العشاء',

            'albums' => 'nullable|array',
            'albums.*' => 'required|image|max:10000',
        ];
    }
}
