<?php

namespace App\Http\Requests\Admin\CategoryRequests;

use Illuminate\Foundation\Http\FormRequest;

class CategoryStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'file' => 'required|image|mimes:jpeg,png,jpg,gif',
            'name.en' => 'required|string|max:254|unique:category_translations,name,NULL,id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:category_translations,name,NULL,id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:category_translations,name,NULL,id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:category_translations,name,NULL,id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:category_translations,name,NULL,id,locale,hi',
        ];
    }
}
