<?php

namespace App\Http\Requests\Admin\RoomRequests;

use Illuminate\Foundation\Http\FormRequest;

class RoomUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            // 'name' => 'required|string|max:254|unique:rooms,name,' . $id
            'hotel_id' => 'required|exists:hotels,id',
            'room_type_id' => 'required|exists:room_types,id',
            // 'info' => 'required|string|max:1255',
            'room_count' => 'required|numeric',
            'person_count' => 'required|numeric',
            'price' => 'required|numeric',
            'file' => 'nullable|mimes:jpeg,png,jpg,webp,webm|max:2048',

            'info.en' => 'required|string|max:1255',
            'info.ar' => 'nullable|string|max:1255',
            'info.fr' => 'nullable|string|max:1255',
            'info.tr' => 'nullable|string|max:1255',
            'info.hi' => 'nullable|string|max:1255',
            
            'options' => 'nullable|array',
            'options.*' => 'required|exists:options,id',
        ];
    }
}
