<?php

namespace App\Http\Requests\Admin\UserRequests;

use Illuminate\Foundation\Http\FormRequest;

class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string|max:254|unique:users,name',
            'email' => 'required|string|max:254|unique:users,email',
            'password' => 'required|confirmed|max:30',
            
            'mobile' => 'required|string|max:254|unique:users,mobile',
            'file' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'user_type' => 'required|in:1,2',
            
            'day_price' => 'required_if:user_type,2|max:254', 
            'hour_price' => 'required_if:user_type,2|max:254', 
            'info' => 'required_if:user_type,2|max:25000', 
            'experience' => 'required_if:user_type,2|max:25000', 
            'country_id' => 'required_if:user_type,2|exists:countries,id',
            
            'interests' => 'required_if:user_type,2|array',
            'interests.*' => 'required_if:user_type,2|max:254',
            'tours_type' => 'required_if:user_type,2|array',
            'tours_type.*' => 'required_if:user_type,2|max:254',
            'languages' => 'required_if:user_type,2|array',
            'languages.*' => 'required_if:user_type,2|exists:languages,id',
            // 'albums' => 'required_if:user_type,2|array',
            // 'albums.*' => 'required_if:user_type,2|max:254',
            
            'days' => 'required|array',
            'days.*.day' => 'required|in:السبت,الاحد,الاثنين,الثلاثاء,الاربعاء,الخميس,الجمعه',
            'days.*.start' => 'nullable|date_format:H:i',
            'days.*.end' => 'nullable|date_format:H:i',
            'days.*.day_status' => 'nullable|in:0,1,2',
        ];
    }
}
