<?php

namespace App\Http\Requests\Admin\UserRequests;

use Illuminate\Foundation\Http\FormRequest;

class UserUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            'name' => 'required|string|max:254|unique:users,name,' . $id,
            'email' => 'required|string|max:254|unique:users,email,' . $id,
            
            'mobile' => 'required|string|max:254|unique:users,mobile,' . $id,
            'file' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'user_type' => 'required|in:1,2',
            'day_price' => 'required|string|max:254', 
            'hour_price' => 'required|string|max:254', 
            'info' => 'required|string|max:25000', 
            'experience' => 'required|string|max:25000', 
            'country_id' => 'required_if:user_type,2|exists:countries,id',

            'interests' => 'required|array',
            'interests.*' => 'required|string',
            'tours_type' => 'required|array',
            'tours_type.*' => 'required|string',
            'languages' => 'required_if:user_type,2|array',
            'languages.*' => 'required_if:user_type,2|exists:languages,id',
            // 'albums' => 'required|array',
            // 'albums.*' => 'required|string',
        ];
    }
}
