<?php

namespace App\Http\Requests\Api\CafeRequesrs;

use Illuminate\Foundation\Http\FormRequest;

class StoreCafeOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'chat_group_id' => 'nullable|exists:chat_groups,id',
            'trip_id' => 'nullable|exists:trips,id',
            'cafe_id' => 'required|exists:cafes,id',
            'day' => 'required|date_format:Y-m-d',
            'table_time' => 'required|string|max:255',
            'persons_count' => 'required|string|max:255',
        ];
    }
}
