<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CarOrder extends Model
{
    protected $table = 'car_orders';
	protected $fillable = [
		'status',
		'car_id',
		'added_by',
		'day',
		'time',
		'current_location',
		'destination',
		'cost',
		'deleted_at',
		'provider_id',
		'chat_group_id',
		'trip_id',
		'canceled_by',
	];
    public $timestamps = true;

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'status' => '',
			'car_id' => '',
			'added_by' => '',
			'day' => '',
			'time' => '',
			'current_location' => '',
			'destination' => '',
			'cost' => '',
			'deleted_at' => '',
			'provider_id' => '',
			'chat_group_id' => '',
			'trip_id' => '',
			'canceled_by' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['car', 'user'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function car()
	{
		return $this->belongsTo(Car::class, 'car_id');	
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'added_by');	
	}

	public function provider()
	{
		return $this->belongsTo(User::class, 'provider_id');	
	}

	public function chat_group()
	{
		return $this->belongsTo(ChatGroup::class, 'chat_group_id');	
	}

	public function orderable()
    {
        return $this->morphMany(WalletTransaction::class, 'orderable');
    }
}