<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class GuideOrder extends Model
{
    protected $table = 'guide_orders';
	protected $fillable = [
		'status',
		'guide_id',
		'added_by',
		'chat_group_id',
		'date',
		'day',
		'time',
		'cost',
		'reservation_type',
		'deleted_at',
		'canceled_by',
	];
    public $timestamps = true;

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'status' => '',
			'guide_id' => '',
			'cost' => '',
			'added_by' => '',
			'chat_group_id' => '',
			'date' => '',
			'day' => '',
			'time' => '',
			'reservation_type' => '',
			'deleted_at' => '',
			'canceled_by' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['guide', 'user'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function guide()
	{
		return $this->belongsTo(User::class, 'guide_id');
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'added_by');	
	}

	public function chat_group()
	{
		return $this->belongsTo(ChatGroup::class, 'chat_group_id');	
	}

	public function orderable()
    {
        return $this->morphMany(WalletTransaction::class, 'orderable');
    }
}