<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('owner', 255)->nullable();
            $table->string('persons_count', 255)->nullable();
            $table->integer('price')->nullable();
            $table->integer('offer')->nullable();
            $table->string('mobile', 255)->nullable();
            $table->string('img', 255)->nullable();
            $table->integer('country_id')->nullable();
            $table->string('attributes', 1255)->nullable();
            $table->integer('captain_id')->nullable();
            $table->integer('owner_id')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cars');
    }
};
