<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            
            $table->string('mobile', 255)->nullable();
            $table->string('img', 255)->nullable();
            $table->string('code', 55)->nullable();
            $table->tinyInteger('user_type')->default(0)->comment('1 => client, 2 => guide, 3 => hotel, 4 => cafe, 5 => car, 6 => restaurant');
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
            
            $table->integer('day_price')->nullable();
            $table->integer('hour_price')->nullable();
            $table->text('info')->nullable();
            $table->text('experience')->nullable();
            $table->text('interests')->nullable();
            $table->text('tours_type')->nullable();
            // $table->text('albums')->nullable();
            $table->integer('country_id')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('fcm_token', 1200)->nullable();
            $table->string('iban', 255)->nullable();
            $table->string('logo', 255)->nullable();
            $table->string('documented_files', 1255)->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
