<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('car_orders', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->tinyInteger('status')->nullable()->comment('1 => pending, 2 => confirmed, 3 => completed, 4 => canceled, 5 => refunded, 6 => user_confirmed');
            $table->integer('car_id')->nullable();
            $table->integer('added_by')->nullable();
            $table->integer('provider_id')->nullable();
            $table->integer('chat_group_id')->nullable();
            $table->integer('trip_id')->nullable();
            $table->date('day')->nullable();
            $table->time('time')->nullable();
            $table->string('current_location', 1255)->nullable();
            $table->string('destination', 1255)->nullable();
            $table->integer('cost')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('canceled_by')->nullable()->comment('1 => from provider , 2 => from client');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('car_orders');
    }
};
