@extends('layouts.front.home')

<!-- title page -->
@section('title')
    <title>DashBoard</title>
@endsection

<!-- custom page -->
@section('css')
@endsection

@section('content')

    <!-- Hero -->
    <section class="hero section section--pad-xl text-center text-white d-flex align-items-center justify-content-center">
        <div class="hero__bg" role="img" aria-label="خلفية طبيعة"></div>
        <div class="container position-relative">
            <h1 class="display-5 fw-bold mb-3 reveal">رحلتك تبدأ مع <span class="text-brand">Tripooo</span>!</h1>
            <p class="lead mb-4 reveal" style="max-width:720px;margin-inline:auto">
                اكتشف أفضل الوجهات حول العالم، احجز تذاكرك
                وخطط رحلتك بسهولة وتمتع بتجربة سفر متكاملة في تطبيق واحد.
            </p>
            <div class="d-flex flex-wrap gap-3 justify-content-center reveal">
                <a class="store-badge" href="#" aria-label="App Store"><img alt="App Store" src="{{ asset('front/images/Group 1171275710.png') }}" /></a>
                <a class="store-badge" href="#" aria-label="Google Play"><img alt="Google Play" src="{{ asset('front/images/Group 1171275711.png') }}" /></a>
            </div>
        </div>
    </section>

    <!-- About -->
    <section id="about" class="section section--pad-lg bg-white">
        <div class="custom-container">
            <div class="row align-items-center g-4">
                <div class="col-lg-6">
                    <div class="reveal" style="padding-right: 20%;text-align: right;">
                        <h1 class="h3 fw-bold mb-3" style="color: #384A95; font-family: Almarai;">من نحن</h1>
                        <h2 class="h3 fw-bold mb-3" style="font-family: Almarai;font-weight: 700; font-size:37px; line-height: 46px;">
                            نحن في <span class="text-brand">Tripooo</span> نسعى لجعل <br>
                            السفر أسهل وأكثر متعة.
                        </h2>
                        <p class="text-muted mb-3" style="font-size: 23px; font-family: Almarai;">
                            في Tripooo نؤمن أن السفر تجربة يجب أن تكون سهلة، ممتعة،
                            ومتكاملة. <br> نجمع في مكان واحد بين المسافرين، المرشدين السياحيين،
                            والفنادق والمطاعم <br> لتوفير تجربة فريدة تشمل كل تفاصيل رحلتك —
                            من التخطيط وحتى الاستمتاع.
                        </p>
                        <p class="text-muted" style="font-size: 23px; font-family: Almarai;">
                            هدفنا هو جعل رحلتك أكثر راحة وتنظيمًا من خلال حلول ذكية تجمع بين الخبرة، <br> التقنية، والمرونة.
                        </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-sm reveal">
                        <img class="object-fit-cover w-100 h-100" src="{{ asset('front/images/WhatsApp Image 2025-10-22 at 08.43.34_1c01834e 1.jpg') }}" alt="طبيعة وحدائق" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services -->
    <section id="services" class="section section--pad-lg bg-light position-relative overflow-hidden" style="text-align: -webkit-center;">
        <img src="{{ asset('front/images/Mask Group.png') }}" alt="Tripooo" style="position: absolute; top: 0; right: 0; height: 62%; opacity: 45%;" />
        <div class="custom-container">
            <div class="mb-4 reveal" style="text-align: right;">
                <h5 style="color: #384A95;">خدماتنا</h5>
                <h2 class="h4 fw-bold">نوفر لك مجموعة متكاملة من الخدمات السياحية</h2>
            </div>
            <div class="row g-4">
                <div class="col-md-6 col-lg-3">
                    <div class="service-card reveal">
                        <div class="service-card__icon">
                            <img class="object-fit-cover w-100 h-100" src="{{ asset('front/images/Frame 111.png') }}" alt="حجز المرشدين السياحيين" />
                        </div>
                        <h3 class="h6 fw-bold mb-1">حجز المرشدين السياحيين</h3>
                        <p class="text-muted mb-0">استعن بمرشدين محليين محترفين لتجارب غنية ومغامرات لا تُنسى.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="service-card reveal">
                        <div class="service-card__icon">
                            <img class="object-fit-cover w-100 h-100" src="{{ asset('front/images/Frame 222.png') }}" alt="الوجهة والفنادق" />
                        </div>
                        <h3 class="h6 fw-bold mb-1">الوجهة والفنادق</h3>
                        <p class="text-muted mb-0">ابحث واحجز بسهولة في أفضل الفنادق حول العالم.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="service-card reveal">
                        <div class="service-card__icon">
                            <img class="object-fit-cover w-100 h-100" src="{{ asset('front/images/Frame 333.png') }}" alt="المطاعم والمقاهي" />
                        </div>
                        <h3 class="h6 fw-bold mb-1">المطاعم والمقاهي</h3>
                        <p class="text-muted mb-0">ابحث واحجز بسهولة في أفضل الفنادق والشقق حول العالم.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="service-card reveal">
                        <div class="service-card__icon">
                            <img class="object-fit-cover w-100 h-100" src="{{ asset('front/images/Frame 444.png') }}" alt="خدمات النقل والعروض" />
                        </div>
                        <h3 class="h6 fw-bold mb-1">خدمات النقل والعروض</h3>
                        <p class="text-muted mb-0">تنقّل بسهولة واستفد من العروض الحصرية عبر التطبيق.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ -->
    <section id="faq" class="section section--pad-lg bg-white">
        <img src="{{ asset('front/images/Mask Group (1).png') }}" alt="Tripooo" style="position: absolute; bottom: 0; left: 0; height: 100%;opacity: 17%;" />
        <div class="container">
            <div class="text-center mb-4 reveal">
                <h2 class="h4 fw-bold">الأسئلة الشائعة</h2>
                <p class="text-muted" style="font-size: larger;">كل ما تحتاج إلى معرفته — تجده هنا.</p>
            </div>
            <div class="accordion accordion-flush reveal" id="faqAcc">
                <div class="accordion-item" style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q1h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button show" type="button" data-bs-toggle="collapse" data-bs-target="#q1" aria-expanded="true">
                            1. ما هو تطبيق Tripooo؟
                        </button>
                    </h2>
                    <div id="q1" class="accordion-collapse collapse show" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            Tripooo هو تطبيق شامل يربط بين المسافرين، المرشدين السياحيين، ومقدمي الخدمات مثل الفنادق
                            والمطاعم لتجربة سفر متكاملة وسهلة.
                        </div>
                    </div>
                </div>
                <div class="accordion-item"
                    style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q2h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q2">
                            2. كيف يمكنني حجز رحلة أو مرشد سياحي؟
                        </button>
                    </h2>
                    <div id="q2" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            ابحث عن الوجهة ثم اختر من النتائج وقم
                            بالدفع داخل التطبيق عبر وسائل متعددة.
                        </div>
                    </div>
                </div>
                <div class="accordion-item"
                    style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q3h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q3">
                            3. هل يمكن لمقدمي الخدمات التسجيل في التطبيق؟
                        </button>
                    </h2>
                    <div id="q3" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            نعم، نوفر بوابة للمزودين للتسجيل وإدارة
                            خدماتهم بسهولة.
                        </div>
                    </div>
                </div>
                <div class="accordion-item"
                    style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q4h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q4">
                            4. هل الدفع يتم من خلال التطبيق؟
                        </button>
                    </h2>
                    <div id="q4" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            يمكنك الدفع ببطاقات الائتمان والمحافظ
                            الرقمية ضمن بوابة دفع آمنة.
                        </div>
                    </div>
                </div>
                <div class="accordion-item"
                    style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q5h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q5">
                            5. كيف أستفيد من نقاط الولاء؟
                        </button>
                    </h2>
                    <div id="q5" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            احصل على نقاط مع كل حجز واستبدلها بخصومات
                            في حجوزاتك القادمة.
                        </div>
                    </div>
                </div>
                <div class="accordion-item"
                    style="margin-bottom: 15px;border-radius: 15px;background: #3D56B2; color: white;">
                    <h2 class="accordion-header" id="q6h">
                        <button style="border-radius: 15px;padding: 28px;font-weight: bold !important;" class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#q6">
                            7. ماذا أفعل إذا واجهت مشكلة أثناء الحجز؟
                        </button>
                    </h2>
                    <div id="q6" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div style="text-align: right;" class="accordion-body">
                            احصل على نقاط مع كل حجز واستبدلها بخصومات
                            في حجوزاتك القادمة.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- App Showcase -->
    <section id="app" class="section section--pad-lg bg-light">
        <div class="container">
            <img src="{{ asset('front/images/Rectangle 164.png') }}" class="bg-mobile-bn phone rounded-4" alt="شعار Tripooo">
            <img src="{{ asset('front/images/Group 5.svg') }}" class="phone rounded-4" alt="شعار Tripooo" style="position: absolute; bottom: 14%; right: 9.5%;">
            <img src="{{ asset('front/images/Group 42.png') }}" class="phone rounded-4" alt="شعار Tripooo" style="position: absolute; bottom: 43%; right: 12%; opacity: 13%;">
            <div class="row align-items-center g-4">
                <div class="col-lg-8 order-lg-2">
                    <div class="phones d-flex gap-3 justify-content-center reveal">
                        <img src="{{ asset('front/images/Group 1171275716.png') }}" class="phone shadow-lg rounded-4" alt="شعار Tripooo" style="z-index: 10">
                    </div>
                </div>
                <div class="col-lg-4 order-lg-1">
                    <div class="text-lg-start text-center reveal" style="z-index: 10">
                        <h2 class="h4 fw-bold mb-2">ذكي وسلس — حمّل تطبيق Tripooo الآن</h2>
                        <p class="text-muted mb-3">
                            استكشف العالم بكل سهولة! مع Tripooo، يمكنك حجز رحلاتك، الفنادق،
                            والمطاعم بخطوة واحدة فقط.  سواء كنت تسافر للاستجمام أو العمل، Tripooo
                            يربطك بأفضل التجارب السياحية بسرعة، وبساطة، وأمان.
                        </p>
                        <div class="d-flex flex-wrap gap-3">
                            <a class="store-badge" href="#" aria-label="App Store"><img alt="App Store" src="{{ asset('front/images/Group 1171275710.png') }}" /></a>
                            <a class="store-badge" href="#" aria-label="Google Play"><img alt="Google Play" src="{{ asset('front/images/Group 1171275711.png') }}" /></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact -->
    <section id="contact" class="section section--pad-lg bg-white">
        <div class="container">
            <div class="d-flex">
                <a href="#contact" class="contact-subtitle">اتصل بنا</a>
            </div>
            <h2 class="contact-title mb-4">نحن هنا لمساعدتك في أي وقت!</h2>
            <div class="row g-4">
                <div class="col-lg-6">
                    <div class="reveal">
                        <div class="info-box mb-4">
                            <span class="info-chip">نحن هنا لأجلك</span>
                            <p class="mb-2">
                                فريق الدعم لدينا متوفر على مدار الساعة طوال أيام الأسبوع
                                لمساعدتك في حجوزات الرحلات، أو حجز المرشدين السياحيين.
                            </p>
                            <p class="mb-0">
                                إذا واجهت مشكلة خلال الدفع، أو كانت لديك حاجة إلى مساعدة مع
                                حجوزاتك، لا تتردد في التواصل معنا — لا تتردد في التواصل.
                            </p>
                        </div>
                        <ul class="list-unstyled vstack gap-3 mt-3">
                            <li class="d-flex align-items-center gap-3">
                                <span class="contact-badge"><i class="bi bi-telephone"></i></span>
                                <span class="fw-medium">+973 17602222</span>
                            </li>
                            <li class="d-flex align-items-center gap-3">
                                <span class="contact-badge"><i class="bi bi-envelope"></i></span>
                                <span class="fw-medium">Rahala@gmail.com</span>
                            </li>
                            <li class="d-flex align-items-center gap-3">
                                <span class="contact-badge"><i class="bi bi-geo-alt"></i></span>
                                <span class="fw-medium">Sahat Al-Janiyya, Bahrain</span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card contact-card border-0 shadow-sm reveal">
                        <div class="card-body p-4" style="border: 1px solid #e2e8f0;border-radius: 12px;">
                            
                            @include('flash::message')
                            @if ($errors->any())
                                <div style="text-align: left; margin: 15px;">
                                    <ul dir="ltr">
                                        @foreach ($errors->all() as $error)
                                            <li class="text-danger">{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <h3 class="h5 fw-bold mb-3">كيف يمكننا مساعدتك؟</h3>

                            <form class="needs-validation" novalidate method="post" action="{{ route('contact') }}">
                                @csrf
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">الاسم الكامل</label>
                                        <input name="name" type="text" class="form-control contact-input" placeholder="ادخل اسمك" required>
                                        <div class="invalid-feedback">يرجى إدخال الاسم.</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">البريد الإلكتروني</label>
                                        <input name="email" type="email" class="form-control contact-input" placeholder="example@mail.com" required>
                                        <div class="invalid-feedback">يرجى إدخال بريد صحيح.</div>
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label">رقم الهاتف</label>
                                        <input name="mobile" type="tel" class="form-control contact-input" placeholder="+966..." required>
                                        <div class="invalid-feedback">يرجى إدخال رقم صحيح.</div>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">الرسالة</label>
                                        <textarea name="message" class="form-control contact-input" rows="4" placeholder="اكتب رسالتك هنا..." required></textarea>
                                        <div class="invalid-feedback">هذا الحقل مطلوب.</div>
                                    </div>
                                    <div class="col-12 d-grid">
                                        <button type="submit" class="btn btn-brand btn-lg">
                                            <i class="bi bi-send me-1"></i> إرسال الرسالة
                                        </button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

<!-- custom js -->
@section('script')
@endsection
