<?php

use App\Http\Controllers\Api\RatingController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CafeController;
use App\Http\Controllers\Api\CarController;
use App\Http\Controllers\Api\ChatController;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\Api\DestinationController;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\HotelController;
use App\Http\Controllers\Api\RestaurantController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\PaymobController;
use App\Http\Controllers\Api\RoomController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::group(['middleware' => ['api', 'limitReq']], function ($router) {

    Route::group(['prefix' => 'auth'], function ($router) {
        Route::post('register', [AuthController::class, 'register']);
        Route::post('login', [AuthController::class, 'login']);
        Route::post('regenerate-code', [AuthController::class, 'regenerateCode']);
        Route::post('mobile-check', [AuthController::class, 'mobileCheck']);
        Route::get('check-token', [AuthController::class, 'checkToken']);

        Route::post('send-reset-code', [AuthController::class, 'sendResetCodePassword']);
        Route::post('verify-reset-code', [AuthController::class, 'verifyResetCodePassword']);
        Route::post('reset', [AuthController::class, 'resetPassword']);
    });

    Route::group(['middleware' => 'userActivation'], function ($router) {

        Route::group(['prefix' => 'auth'], function ($router) {
            Route::get('/', [AuthController::class, 'me']);
            Route::get('refresh', [AuthController::class, 'refresh']);
            Route::post('change-password', [AuthController::class, 'changePassword']);
            Route::post('/change-mobile-number', [AuthController::class, 'changeMobileNum']);
            Route::post('/update', [AuthController::class, 'userUpdate']);
            Route::post('/guide/album', [AuthController::class, 'guideAlbum']);
            Route::post('logout', [AuthController::class, 'logout']);
            Route::get('delete-account', [AuthController::class, 'deleteAccount']);
            Route::get('/statistics', [AuthController::class, 'statistics']);
            Route::get('/points', [AuthController::class, 'points']);
            Route::get('/notifications', [AuthController::class, 'notifications']);
            Route::get('/favorates', [AuthController::class, 'favorates']);
            Route::get('/favorates/remove', [AuthController::class, 'removeFromFavorates']);
        });
        
        Route::group(['prefix' => 'cars'], function ($router) {
            Route::post('/store', [CarController::class, 'store']);
            Route::post('/update/{id?}', [CarController::class, 'update']);
            Route::post('/order', [CarController::class, 'makeOrder']);
            Route::post('/check-order-date/{offset?}', [CarController::class, 'checkOrderDate']);
            Route::get('/order/{id?}', [CarController::class, 'getOrder']);
            Route::get('/favorate/{id?}', [CarController::class, 'addToFavorate']);
            Route::get('/my-items/{offset?}/{limit?}', [CarController::class, 'myItems']);
            Route::get('/activate/{id?}', [CarController::class, 'activate']);
            Route::get('/my-orders/{offset?}/{limit?}', [CarController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [CarController::class, 'orderStatus']);
        });
    
        Route::group(['prefix' => 'restaurants'], function ($router) {
            Route::post('/store', [RestaurantController::class, 'store']);
            Route::post('/update/{id?}', [RestaurantController::class, 'update']);
            Route::post('/order', [RestaurantController::class, 'makeOrder']);
            Route::get('/order/{id?}', [RestaurantController::class, 'getOrder']);
            Route::get('/favorate/{id?}', [RestaurantController::class, 'addToFavorate']);
            Route::get('/my-items/{offset?}/{limit?}', [RestaurantController::class, 'myItems']);
            Route::get('/activate/{id?}', [RestaurantController::class, 'activate']);
            Route::get('/my-orders/{offset?}/{limit?}', [RestaurantController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [RestaurantController::class, 'orderStatus']);
        });
        
        Route::group(['prefix' => 'hotels'], function ($router) {
            Route::post('/store', [HotelController::class, 'store']);
            Route::post('/update/{id?}', [HotelController::class, 'update']);
            Route::post('/order', [HotelController::class, 'makeOrder']);
            Route::post('/check-order-date', [HotelController::class, 'checkOrderDate']);
            Route::get('/order/{id?}', [HotelController::class, 'getOrder']);
            Route::get('/favorate/{id?}', [HotelController::class, 'addToFavorate']);
            Route::get('/my-items/{offset?}/{limit?}', [HotelController::class, 'myItems']);
            Route::get('/activate/{id?}', [HotelController::class, 'activate']);
            Route::get('/my-orders/{offset?}/{limit?}', [HotelController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [HotelController::class, 'orderStatus']);
        });
        
        Route::group(['prefix' => 'rooms'], function ($router) {
            Route::post('/store', [RoomController::class, 'store']);
            Route::post('/update/{id?}', [RoomController::class, 'update']);
            Route::get('/activate/{id?}', [RoomController::class, 'activate']);
        });
        
        Route::group(['prefix' => 'cafes'], function ($router) {
            Route::post('/store', [CafeController::class, 'store']);
            Route::post('/update/{id?}', [CafeController::class, 'update']);
            Route::post('/order', [CafeController::class, 'makeOrder']);
            Route::get('/order/{id?}', [CafeController::class, 'getOrder']);
            Route::get('/favorate/{id?}', [CafeController::class, 'addToFavorate']);
            Route::get('/my-items/{offset?}/{limit?}', [CafeController::class, 'myItems']);
            Route::get('/activate/{id?}', [CafeController::class, 'activate']);
            Route::get('/my-orders/{offset?}/{limit?}', [CafeController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [CafeController::class, 'orderStatus']);
        });
        
        Route::group(['prefix' => 'guides'], function ($router) {
            Route::post('/order', [UserController::class, 'makeOrder']);
            Route::get('/order/{id?}', [UserController::class, 'getOrder']);
            Route::get('/favorate/{id?}', [UserController::class, 'addToFavorate']);
            Route::get('/my-orders/{offset?}/{limit?}', [UserController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [UserController::class, 'orderStatus']);
        });
        
        Route::group(['prefix' => 'clients'], function ($router) {
            Route::get('/my-orders/{offset?}/{limit?}', [ClientController::class, 'myOrders']);
            Route::get('/order/status/{id?}', [ClientController::class, 'orderStatus']);
        });
        
        Route::group(['prefix' => 'ratings'], function ($router) {
            Route::post('/', [RatingController::class, 'rating']);
        });
        
        Route::group(['prefix' => 'destinations'], function ($router) {
            Route::post('/store', [DestinationController::class, 'store']);
            Route::post('/update/{id?}', [DestinationController::class, 'update']);
            Route::get('/favorate/{id?}', [DestinationController::class, 'addToFavorate']);
            Route::get('/my-items/{offset?}/{limit?}', [DestinationController::class, 'myItems']);
            Route::get('/activate/{id?}', [DestinationController::class, 'activate']);
        });
    
        Route::group(['prefix' => 'wallet'], function ($router) {
            Route::post('/deposit', [WalletController::class, 'deposit']);
            Route::post('/withdrow', [WalletController::class, 'withdrow']);
            Route::post('/barq/callback', [WalletController::class, 'barqCallback'])->name('barq/callback');
        });
    
        Route::group(['prefix' => 'chat'], function ($router) {
            Route::post('/messages', [ChatController::class, 'messages']);
            Route::post('/message/votes', [ChatController::class, 'messageVotes']);
            Route::get('/groups', [ChatController::class, 'groups']);
            Route::get('/group/{id?}/{messages_page?}', [ChatController::class, 'group']);
            Route::post('/groups/store', [ChatController::class, 'addGroup']);
            Route::get('/trip/{id?}', [ChatController::class, 'trip']);
            Route::post('/groups/trips/store', [ChatController::class, 'addTrip']);
            Route::post('/groups/remove', [ChatController::class, 'removeGroup']);
            Route::post('/groups/members', [ChatController::class, 'addMembers']);
            Route::get('/group/members/wallet/{id?}', [ChatController::class, 'membersWallet']);
            Route::post('/groups/members/remove', [ChatController::class, 'removeMembers']);
            Route::post('/groups/media', [ChatController::class, 'addMedia']);
            Route::post('/groups/media/remove', [ChatController::class, 'removeMedia']);
            Route::post('/groups/checkUsers', [ChatController::class, 'checkUsers']);
            Route::get('/group/read/messages/{id?}', [ChatController::class, 'readMessages']);
            Route::post('/media/interaction', [ChatController::class, 'addMediaInteraction']);
        });
    });

    Route::group(['prefix' => 'cars'], function ($router) {
        Route::get('/details/{id?}', [CarController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [CarController::class, 'cars']);
    });

    Route::group(['prefix' => 'destinations'], function ($router) {
        Route::get('/details/{id?}', [DestinationController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [DestinationController::class, 'destinations']);
    });

    Route::group(['prefix' => 'restaurants'], function ($router) {
        Route::get('/details/{id?}', [RestaurantController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [RestaurantController::class, 'restaurants']);
    });

    Route::group(['prefix' => 'hotels'], function ($router) {
        Route::get('/details/{id?}', [HotelController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [HotelController::class, 'hotels']);
    });

    Route::group(['prefix' => 'rooms'], function ($router) {
        Route::get('/details/{id?}', [RoomController::class, 'details']);
    });

    Route::group(['prefix' => 'cafes'], function ($router) {
        Route::get('/details/{id?}', [CafeController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [CafeController::class, 'cafes']);
    });

    Route::group(['prefix' => 'guides'], function ($router) {
        Route::get('/details/{id?}', [UserController::class, 'details']);
        Route::get('/{offset?}/{limit?}', [UserController::class, 'guides']);
    });

    Route::get('/pay/callback', [PaymobController::class, 'callback']);
    Route::get('/pay/webhook', [PaymobController::class, 'webhook']);

    Route::get('info', [HomeController::class, 'info']);
    Route::post('test', [HomeController::class, 'test']);
    Route::get('options', [HomeController::class, 'options']);
    Route::get('room-types', [HomeController::class, 'roomTypes']);
    Route::get('countries', [HomeController::class, 'countries']);
    Route::get('languages', [HomeController::class, 'languages']);
});